
uniform sampler2D maske;
//NORMAL, MULTI_POSITIVE, MULTI2_POSITIVE, MULTI_INVERT, MULTI2_INVERT, MULTI3_INVERT, MULTI2_SHAPEVEC, MULTI3_POSITIVE, MULTI4_INVERT
  
uniform sampler2D tex1;
uniform sampler2D tex2;
uniform sampler2D tex3;
uniform sampler2D tex4;

uniform vec4 texColor1;
uniform vec4 texColor2;
uniform vec4 texColor3;
uniform vec4 texColor4;

uniform int invert;

uniform int renderMode;

void main()
{
  vec4 pixel;
  
  if (renderMode == 3) //MULTI_INVERT
  {
    vec4 texTexel = texture2D(tex1, gl_TexCoord[1].st) * vec4(texColor1.rgb, 1);
    vec4 maskTexel = texture2D(maske, gl_TexCoord[0].st);
    
    //get the alpha value
    float alpha = 0.0;
    if (maskTexel.r > 0.6 || maskTexel.a < 1.0) {
      alpha = maskTexel.a;
      maskTexel.rgb = maskTexel.rgb * vec3(0.8);
    }
    else {
      alpha = texTexel.a;
    }
      
    vec3 finalColor = texTexel.rgb + maskTexel.rgb - texTexel.rgb * maskTexel.rgb;
    pixel = vec4(finalColor, alpha);
  }
  
  else if (renderMode == 0) //NORMAL              
  {
    if (invert == 1) {
      vec4 maskTexl = texture2D(maske, gl_TexCoord[0].st);
      pixel = vec4(vec3(1,1,1) - maskTexl.rgb, maskTexl.a);
    }
    else
      pixel = texture2D(maske, gl_TexCoord[0].st);
  }
  
  else if (renderMode == 1) //MULTI_POSITIVE
  {
    vec4 texTexel = texture2D(tex1, gl_TexCoord[1].st);
    vec3 blendedTexTexel = texTexel.rgb * texColor1.rgb;
    vec4 maskTexel = texture2D(maske, gl_TexCoord[0].st);
    
    pixel.rgb = mix(maskTexel.rgb, blendedTexTexel, texColor1.a * texTexel.a);
    if (texColor1.a < 0.98)
      pixel.a = maskTexel.a;
    else
      pixel.a = maskTexel.a * texTexel.a;
  }
  
  else if (renderMode == 2 || renderMode == 6) //MULTI2_POSITIVE or MULTI2_SHAPEVEC            
  {
    vec4 alphaMaskTexel = texture2D(tex1, gl_TexCoord[1].st);
    vec4 maskTexel = texture2D(maske, gl_TexCoord[0].st);
    pixel = mix( maskTexel, texture2D(tex2, gl_TexCoord[2].st), alphaMaskTexel.a );
    pixel.a = maskTexel.a;
  }
  
  else if (renderMode == 5) //MULTI3_INVERT
  {
    //vec4 texTexel = texture2D(tex1, gl_TexCoord[1].st) * texture2D(tex2, gl_TexCoord[2].st) * texture2D(tex3, gl_TexCoord[3].st);
    vec4 texTexel1 = texture2D(tex1, gl_TexCoord[1].st);
    vec4 texTexel2 = texture2D(tex3, gl_TexCoord[3].st);
    vec4 texTexel = mix(texTexel1, texTexel2, texture2D(tex2, gl_TexCoord[2].st).a  * texColor2.a);
    vec4 maskTexel = texture2D(maske, gl_TexCoord[0].st);
    
    
    //get the alpha value
    float alpha = 0.0;
    if (maskTexel.r > 0.6 || maskTexel.a < 1.0) {
      alpha = maskTexel.a;
      maskTexel.rgb = maskTexel.rgb * vec3(0.8);
    }
    else {
      alpha = texTexel.a;
    }
      
    vec3 finalColor = texTexel.rgb + maskTexel.rgb - texTexel.rgb * maskTexel.rgb;
    pixel = vec4(finalColor, alpha);
  }
  
  else if (renderMode == 7) //MULTI3_POSITIVE
  {
    //vec4 texTexel = texture2D(tex1, gl_TexCoord[1].st) * texture2D(tex2, gl_TexCoord[2].st) * texture2D(tex3, gl_TexCoord[3].st);
    vec4 texTexel1 = texture2D(tex1, gl_TexCoord[1].st);
    vec4 texTexel2 = texture2D(tex3, gl_TexCoord[3].st);
    vec4 texTexel = mix(texTexel1, texTexel2, texture2D(tex2, gl_TexCoord[2].st).a );
    
    pixel = texture2D(maske, gl_TexCoord[0].st) * texTexel;
  }
  
  else if (renderMode == 8) //MULTI4_INVERT
  {
    vec4 baseTexel = mix( texture2D(tex1, gl_TexCoord[1].st), texture2D(tex4, gl_TexCoord[4].st), texColor4.a );
    vec4 texTexel = mix(baseTexel, texture2D(tex3, gl_TexCoord[3].st), texture2D(tex2, gl_TexCoord[2].st).a * texColor2.a);
//    vec4 texTexel = mix( texture2D(tex1, gl_TexCoord[1].st), texture2D(tex4, gl_TexCoord[4].st), texColor4.a );
    vec4 maskTexel = texture2D(maske, gl_TexCoord[0].st);
    
    //get the alpha value
    float alpha = 0.0;
    if (maskTexel.r > 0.6 || maskTexel.a < 1.0) {
      alpha = maskTexel.a;
      maskTexel.rgb = maskTexel.rgb * vec3(0.8);
    }
    else {
      alpha = texTexel.a;
    }
      
    vec3 finalColor = texTexel.rgb + maskTexel.rgb - texTexel.rgb * maskTexel.rgb;
    pixel = vec4(finalColor, alpha);
  }
  
  else if (renderMode == 4) //MULTI2_INVERT
  {
    vec4 texTexel1 = texture2D(tex1, gl_TexCoord[1].st);
    vec4 texTexel2 = texture2D(tex2, gl_TexCoord[2].st);
    vec4 texTexel = mix(texTexel1, texTexel2, texTexel2.a * texColor2.a);
    vec4 maskTexel = texture2D(maske, gl_TexCoord[0].st);
    
    if (maskTexel.r > 0.6 || maskTexel.a < 1.0) {
      maskTexel.rgb = maskTexel.rgb * vec3(0.8);
    }
      
    vec3 finalColor = texTexel.rgb + maskTexel.rgb - texTexel.rgb * maskTexel.rgb;
    pixel = vec4(finalColor, maskTexel.a);
  }
  
  //float mean = max(max(pixel.r, pixel.g), pixel.b);
  gl_FragColor = pixel * gl_Color;
  
}
